// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataProtectionBackup.Models
{
    /// <summary> Unknown version of BaseBackupPolicy. </summary>
    internal partial class UnknownBaseBackupPolicy : DataProtectionBackupPolicyPropertiesBase
    {
        /// <summary> Initializes a new instance of <see cref="UnknownBaseBackupPolicy"/>. </summary>
        /// <param name="dataSourceTypes"> Type of datasource for the backup management. </param>
        /// <param name="objectType"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal UnknownBaseBackupPolicy(IList<string> dataSourceTypes, string objectType, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(dataSourceTypes, objectType, serializedAdditionalRawData)
        {
            ObjectType = objectType ?? "Unknown";
        }

        /// <summary> Initializes a new instance of <see cref="UnknownBaseBackupPolicy"/> for deserialization. </summary>
        internal UnknownBaseBackupPolicy()
        {
        }
    }
}
