// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataProtectionBackup.Models
{
    /// <summary> Unknown version of BackupParameters. </summary>
    internal partial class UnknownBackupParameters : DataProtectionBackupSettingsBase
    {
        /// <summary> Initializes a new instance of <see cref="UnknownBackupParameters"/>. </summary>
        /// <param name="objectType"> Type of the specific object - used for deserializing. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal UnknownBackupParameters(string objectType, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(objectType, serializedAdditionalRawData)
        {
            ObjectType = objectType ?? "Unknown";
        }

        /// <summary> Initializes a new instance of <see cref="UnknownBackupParameters"/> for deserialization. </summary>
        internal UnknownBackupParameters()
        {
        }
    }
}
