// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataProtectionBackup.Models
{
    /// <summary> Gets or sets the type. </summary>
    public readonly partial struct StorageSettingType : IEquatable<StorageSettingType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="StorageSettingType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public StorageSettingType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string GeoRedundantValue = "GeoRedundant";
        private const string LocallyRedundantValue = "LocallyRedundant";
        private const string ZoneRedundantValue = "ZoneRedundant";

        /// <summary> GeoRedundant. </summary>
        public static StorageSettingType GeoRedundant { get; } = new StorageSettingType(GeoRedundantValue);
        /// <summary> LocallyRedundant. </summary>
        public static StorageSettingType LocallyRedundant { get; } = new StorageSettingType(LocallyRedundantValue);
        /// <summary> ZoneRedundant. </summary>
        public static StorageSettingType ZoneRedundant { get; } = new StorageSettingType(ZoneRedundantValue);
        /// <summary> Determines if two <see cref="StorageSettingType"/> values are the same. </summary>
        public static bool operator ==(StorageSettingType left, StorageSettingType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="StorageSettingType"/> values are not the same. </summary>
        public static bool operator !=(StorageSettingType left, StorageSettingType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="StorageSettingType"/>. </summary>
        public static implicit operator StorageSettingType(string value) => new StorageSettingType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is StorageSettingType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(StorageSettingType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
