// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataProtectionBackup.Models
{
    /// <summary> Gets or sets the type of the datastore. </summary>
    public readonly partial struct StorageSettingStoreType : IEquatable<StorageSettingStoreType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="StorageSettingStoreType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public StorageSettingStoreType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ArchiveStoreValue = "ArchiveStore";
        private const string OperationalStoreValue = "OperationalStore";
        private const string VaultStoreValue = "VaultStore";

        /// <summary> ArchiveStore. </summary>
        public static StorageSettingStoreType ArchiveStore { get; } = new StorageSettingStoreType(ArchiveStoreValue);
        /// <summary> OperationalStore. </summary>
        public static StorageSettingStoreType OperationalStore { get; } = new StorageSettingStoreType(OperationalStoreValue);
        /// <summary> VaultStore. </summary>
        public static StorageSettingStoreType VaultStore { get; } = new StorageSettingStoreType(VaultStoreValue);
        /// <summary> Determines if two <see cref="StorageSettingStoreType"/> values are the same. </summary>
        public static bool operator ==(StorageSettingStoreType left, StorageSettingStoreType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="StorageSettingStoreType"/> values are not the same. </summary>
        public static bool operator !=(StorageSettingStoreType left, StorageSettingStoreType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="StorageSettingStoreType"/>. </summary>
        public static implicit operator StorageSettingStoreType(string value) => new StorageSettingStoreType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is StorageSettingStoreType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(StorageSettingStoreType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
