// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataProtectionBackup.Models
{
    /// <summary> Gets or sets the type of secret store. </summary>
    public readonly partial struct SecretStoreType : IEquatable<SecretStoreType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SecretStoreType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SecretStoreType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InvalidValue = "Invalid";
        private const string AzureKeyVaultValue = "AzureKeyVault";

        /// <summary> Invalid. </summary>
        public static SecretStoreType Invalid { get; } = new SecretStoreType(InvalidValue);
        /// <summary> AzureKeyVault. </summary>
        public static SecretStoreType AzureKeyVault { get; } = new SecretStoreType(AzureKeyVaultValue);
        /// <summary> Determines if two <see cref="SecretStoreType"/> values are the same. </summary>
        public static bool operator ==(SecretStoreType left, SecretStoreType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SecretStoreType"/> values are not the same. </summary>
        public static bool operator !=(SecretStoreType left, SecretStoreType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SecretStoreType"/>. </summary>
        public static implicit operator SecretStoreType(string value) => new SecretStoreType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SecretStoreType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SecretStoreType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
