// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataProtectionBackup.Models
{
    /// <summary> Class representing a secret store resource. </summary>
    public partial class SecretStoreResourceInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SecretStoreResourceInfo"/>. </summary>
        /// <param name="secretStoreType"> Gets or sets the type of secret store. </param>
        public SecretStoreResourceInfo(SecretStoreType secretStoreType)
        {
            SecretStoreType = secretStoreType;
        }

        /// <summary> Initializes a new instance of <see cref="SecretStoreResourceInfo"/>. </summary>
        /// <param name="uri"> Uri to get to the resource. </param>
        /// <param name="secretStoreType"> Gets or sets the type of secret store. </param>
        /// <param name="value"> Gets or sets value stored in secret store resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SecretStoreResourceInfo(Uri uri, SecretStoreType secretStoreType, string value, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Uri = uri;
            SecretStoreType = secretStoreType;
            Value = value;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="SecretStoreResourceInfo"/> for deserialization. </summary>
        internal SecretStoreResourceInfo()
        {
        }

        /// <summary> Uri to get to the resource. </summary>
        public Uri Uri { get; set; }
        /// <summary> Gets or sets the type of secret store. </summary>
        public SecretStoreType SecretStoreType { get; set; }
        /// <summary> Gets or sets value stored in secret store resource. </summary>
        public string Value { get; set; }
    }
}
