// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataProtectionBackup.Models
{
    /// <summary> Schedule based backup criteria. </summary>
    public partial class ScheduleBasedBackupCriteria : DataProtectionBackupCriteria
    {
        /// <summary> Initializes a new instance of <see cref="ScheduleBasedBackupCriteria"/>. </summary>
        public ScheduleBasedBackupCriteria()
        {
            AbsoluteCriteria = new ChangeTrackingList<BackupAbsoluteMarker>();
            DaysOfMonth = new ChangeTrackingList<DataProtectionBackupDay>();
            DaysOfWeek = new ChangeTrackingList<DataProtectionBackupDayOfWeek>();
            MonthsOfYear = new ChangeTrackingList<DataProtectionBackupMonth>();
            ScheduleTimes = new ChangeTrackingList<DateTimeOffset>();
            WeeksOfMonth = new ChangeTrackingList<DataProtectionBackupWeekNumber>();
            ObjectType = "ScheduleBasedBackupCriteria";
        }

        /// <summary> Initializes a new instance of <see cref="ScheduleBasedBackupCriteria"/>. </summary>
        /// <param name="objectType"> Type of the specific object - used for deserializing. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="absoluteCriteria">
        /// it contains absolute values like "AllBackup" / "FirstOfDay" / "FirstOfWeek" / "FirstOfMonth"
        /// and should be part of AbsoluteMarker enum
        /// </param>
        /// <param name="daysOfMonth"> This is day of the month from 1 to 28 other wise last of month. </param>
        /// <param name="daysOfWeek"> It should be Sunday/Monday/T..../Saturday. </param>
        /// <param name="monthsOfYear"> It should be January/February/....../December. </param>
        /// <param name="scheduleTimes"> List of schedule times for backup. </param>
        /// <param name="weeksOfMonth"> It should be First/Second/Third/Fourth/Last. </param>
        internal ScheduleBasedBackupCriteria(string objectType, IDictionary<string, BinaryData> serializedAdditionalRawData, IList<BackupAbsoluteMarker> absoluteCriteria, IList<DataProtectionBackupDay> daysOfMonth, IList<DataProtectionBackupDayOfWeek> daysOfWeek, IList<DataProtectionBackupMonth> monthsOfYear, IList<DateTimeOffset> scheduleTimes, IList<DataProtectionBackupWeekNumber> weeksOfMonth) : base(objectType, serializedAdditionalRawData)
        {
            AbsoluteCriteria = absoluteCriteria;
            DaysOfMonth = daysOfMonth;
            DaysOfWeek = daysOfWeek;
            MonthsOfYear = monthsOfYear;
            ScheduleTimes = scheduleTimes;
            WeeksOfMonth = weeksOfMonth;
            ObjectType = objectType ?? "ScheduleBasedBackupCriteria";
        }

        /// <summary>
        /// it contains absolute values like "AllBackup" / "FirstOfDay" / "FirstOfWeek" / "FirstOfMonth"
        /// and should be part of AbsoluteMarker enum
        /// </summary>
        public IList<BackupAbsoluteMarker> AbsoluteCriteria { get; }
        /// <summary> This is day of the month from 1 to 28 other wise last of month. </summary>
        public IList<DataProtectionBackupDay> DaysOfMonth { get; }
        /// <summary> It should be Sunday/Monday/T..../Saturday. </summary>
        public IList<DataProtectionBackupDayOfWeek> DaysOfWeek { get; }
        /// <summary> It should be January/February/....../December. </summary>
        public IList<DataProtectionBackupMonth> MonthsOfYear { get; }
        /// <summary> List of schedule times for backup. </summary>
        public IList<DateTimeOffset> ScheduleTimes { get; }
        /// <summary> It should be First/Second/Third/Fourth/Last. </summary>
        public IList<DataProtectionBackupWeekNumber> WeeksOfMonth { get; }
    }
}
