// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.DataProtectionBackup.Models
{
    /// <summary> Rule based backup policy. </summary>
    public partial class RuleBasedBackupPolicy : DataProtectionBackupPolicyPropertiesBase
    {
        /// <summary> Initializes a new instance of <see cref="RuleBasedBackupPolicy"/>. </summary>
        /// <param name="dataSourceTypes"> Type of datasource for the backup management. </param>
        /// <param name="policyRules">
        /// Policy rule dictionary that contains rules for each backuptype i.e Full/Incremental/Logs etc
        /// Please note <see cref="DataProtectionBasePolicyRule"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="DataProtectionBackupRule"/> and <see cref="DataProtectionRetentionRule"/>.
        /// </param>
        /// <exception cref="ArgumentNullException"> <paramref name="dataSourceTypes"/> or <paramref name="policyRules"/> is null. </exception>
        public RuleBasedBackupPolicy(IEnumerable<string> dataSourceTypes, IEnumerable<DataProtectionBasePolicyRule> policyRules) : base(dataSourceTypes)
        {
            Argument.AssertNotNull(dataSourceTypes, nameof(dataSourceTypes));
            Argument.AssertNotNull(policyRules, nameof(policyRules));

            PolicyRules = policyRules.ToList();
            ObjectType = "BackupPolicy";
        }

        /// <summary> Initializes a new instance of <see cref="RuleBasedBackupPolicy"/>. </summary>
        /// <param name="dataSourceTypes"> Type of datasource for the backup management. </param>
        /// <param name="objectType"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="policyRules">
        /// Policy rule dictionary that contains rules for each backuptype i.e Full/Incremental/Logs etc
        /// Please note <see cref="DataProtectionBasePolicyRule"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="DataProtectionBackupRule"/> and <see cref="DataProtectionRetentionRule"/>.
        /// </param>
        internal RuleBasedBackupPolicy(IList<string> dataSourceTypes, string objectType, IDictionary<string, BinaryData> serializedAdditionalRawData, IList<DataProtectionBasePolicyRule> policyRules) : base(dataSourceTypes, objectType, serializedAdditionalRawData)
        {
            PolicyRules = policyRules;
            ObjectType = objectType ?? "BackupPolicy";
        }

        /// <summary> Initializes a new instance of <see cref="RuleBasedBackupPolicy"/> for deserialization. </summary>
        internal RuleBasedBackupPolicy()
        {
        }

        /// <summary>
        /// Policy rule dictionary that contains rules for each backuptype i.e Full/Incremental/Logs etc
        /// Please note <see cref="DataProtectionBasePolicyRule"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="DataProtectionBackupRule"/> and <see cref="DataProtectionRetentionRule"/>.
        /// </summary>
        public IList<DataProtectionBasePolicyRule> PolicyRules { get; }
    }
}
