// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataProtectionBackup.Models
{
    /// <summary> Type of the specific object - used for deserializing. </summary>
    internal readonly partial struct ResourcePropertiesObjectType : IEquatable<ResourcePropertiesObjectType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ResourcePropertiesObjectType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ResourcePropertiesObjectType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DefaultResourcePropertiesValue = "DefaultResourceProperties";

        /// <summary> DefaultResourceProperties. </summary>
        public static ResourcePropertiesObjectType DefaultResourceProperties { get; } = new ResourcePropertiesObjectType(DefaultResourcePropertiesValue);
        /// <summary> Determines if two <see cref="ResourcePropertiesObjectType"/> values are the same. </summary>
        public static bool operator ==(ResourcePropertiesObjectType left, ResourcePropertiesObjectType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ResourcePropertiesObjectType"/> values are not the same. </summary>
        public static bool operator !=(ResourcePropertiesObjectType left, ResourcePropertiesObjectType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ResourcePropertiesObjectType"/>. </summary>
        public static implicit operator ResourcePropertiesObjectType(string value) => new ResourcePropertiesObjectType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ResourcePropertiesObjectType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ResourcePropertiesObjectType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
