// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataProtectionBackup.Models
{
    /// <summary> List of ResourceGuardProxyBase resources. </summary>
    internal partial class ResourceGuardProxyBaseResourceList : DppResourceList
    {
        /// <summary> Initializes a new instance of <see cref="ResourceGuardProxyBaseResourceList"/>. </summary>
        internal ResourceGuardProxyBaseResourceList()
        {
            Value = new ChangeTrackingList<ResourceGuardProxyBaseResourceData>();
        }

        /// <summary> Initializes a new instance of <see cref="ResourceGuardProxyBaseResourceList"/>. </summary>
        /// <param name="nextLink"> The uri to fetch the next page of resources. Call ListNext() fetches next page of resources. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="value"> List of resources. </param>
        internal ResourceGuardProxyBaseResourceList(string nextLink, IDictionary<string, BinaryData> serializedAdditionalRawData, IReadOnlyList<ResourceGuardProxyBaseResourceData> value) : base(nextLink, serializedAdditionalRawData)
        {
            Value = value;
        }

        /// <summary> List of resources. </summary>
        public IReadOnlyList<ResourceGuardProxyBaseResourceData> Value { get; }
    }
}
