// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataProtectionBackup.Models
{
    /// <summary> VaultCritical Operation protected by a resource guard. </summary>
    public partial class ResourceGuardOperationDetail
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ResourceGuardOperationDetail"/>. </summary>
        public ResourceGuardOperationDetail()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ResourceGuardOperationDetail"/>. </summary>
        /// <param name="vaultCriticalOperation"></param>
        /// <param name="defaultResourceRequest"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ResourceGuardOperationDetail(string vaultCriticalOperation, string defaultResourceRequest, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            VaultCriticalOperation = vaultCriticalOperation;
            DefaultResourceRequest = defaultResourceRequest;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets or sets the vault critical operation. </summary>
        public string VaultCriticalOperation { get; set; }
        /// <summary> Gets or sets the default resource request. </summary>
        public string DefaultResourceRequest { get; set; }
    }
}
