// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataProtectionBackup.Models
{
    /// <summary> Recovery Option. </summary>
    public readonly partial struct RecoverySetting : IEquatable<RecoverySetting>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RecoverySetting"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RecoverySetting(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string FailIfExistsValue = "FailIfExists";

        /// <summary> FailIfExists. </summary>
        public static RecoverySetting FailIfExists { get; } = new RecoverySetting(FailIfExistsValue);
        /// <summary> Determines if two <see cref="RecoverySetting"/> values are the same. </summary>
        public static bool operator ==(RecoverySetting left, RecoverySetting right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RecoverySetting"/> values are not the same. </summary>
        public static bool operator !=(RecoverySetting left, RecoverySetting right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RecoverySetting"/>. </summary>
        public static implicit operator RecoverySetting(string value) => new RecoverySetting(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RecoverySetting other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RecoverySetting other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
