// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataProtectionBackup.Models
{
    /// <summary> The RecoveryPointDataStoreRehydrationStatus. </summary>
    public readonly partial struct RecoveryPointDataStoreRehydrationStatus : IEquatable<RecoveryPointDataStoreRehydrationStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RecoveryPointDataStoreRehydrationStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RecoveryPointDataStoreRehydrationStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CreateInProgressValue = "CREATE_IN_PROGRESS";
        private const string CompletedValue = "COMPLETED";
        private const string DeleteInProgressValue = "DELETE_IN_PROGRESS";
        private const string DeletedValue = "DELETED";
        private const string FailedValue = "FAILED";

        /// <summary> CREATE_IN_PROGRESS. </summary>
        public static RecoveryPointDataStoreRehydrationStatus CreateInProgress { get; } = new RecoveryPointDataStoreRehydrationStatus(CreateInProgressValue);
        /// <summary> COMPLETED. </summary>
        public static RecoveryPointDataStoreRehydrationStatus Completed { get; } = new RecoveryPointDataStoreRehydrationStatus(CompletedValue);
        /// <summary> DELETE_IN_PROGRESS. </summary>
        public static RecoveryPointDataStoreRehydrationStatus DeleteInProgress { get; } = new RecoveryPointDataStoreRehydrationStatus(DeleteInProgressValue);
        /// <summary> DELETED. </summary>
        public static RecoveryPointDataStoreRehydrationStatus Deleted { get; } = new RecoveryPointDataStoreRehydrationStatus(DeletedValue);
        /// <summary> FAILED. </summary>
        public static RecoveryPointDataStoreRehydrationStatus Failed { get; } = new RecoveryPointDataStoreRehydrationStatus(FailedValue);
        /// <summary> Determines if two <see cref="RecoveryPointDataStoreRehydrationStatus"/> values are the same. </summary>
        public static bool operator ==(RecoveryPointDataStoreRehydrationStatus left, RecoveryPointDataStoreRehydrationStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RecoveryPointDataStoreRehydrationStatus"/> values are not the same. </summary>
        public static bool operator !=(RecoveryPointDataStoreRehydrationStatus left, RecoveryPointDataStoreRehydrationStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RecoveryPointDataStoreRehydrationStatus"/>. </summary>
        public static implicit operator RecoveryPointDataStoreRehydrationStatus(string value) => new RecoveryPointDataStoreRehydrationStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RecoveryPointDataStoreRehydrationStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RecoveryPointDataStoreRehydrationStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
