// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataProtectionBackup.Models
{
    /// <summary> RecoveryPoint datastore details. </summary>
    public partial class RecoveryPointDataStoreDetail
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RecoveryPointDataStoreDetail"/>. </summary>
        public RecoveryPointDataStoreDetail()
        {
        }

        /// <summary> Initializes a new instance of <see cref="RecoveryPointDataStoreDetail"/>. </summary>
        /// <param name="createdOn"></param>
        /// <param name="expireOn"></param>
        /// <param name="recoveryPointDataStoreId"></param>
        /// <param name="metadata"></param>
        /// <param name="state"></param>
        /// <param name="recoveryPointDataStoreType"></param>
        /// <param name="isVisible"></param>
        /// <param name="rehydrationExpireOn"></param>
        /// <param name="rehydrationStatus"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RecoveryPointDataStoreDetail(DateTimeOffset? createdOn, DateTimeOffset? expireOn, Guid? recoveryPointDataStoreId, string metadata, string state, string recoveryPointDataStoreType, bool? isVisible, DateTimeOffset? rehydrationExpireOn, RecoveryPointDataStoreRehydrationStatus? rehydrationStatus, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            CreatedOn = createdOn;
            ExpireOn = expireOn;
            RecoveryPointDataStoreId = recoveryPointDataStoreId;
            Metadata = metadata;
            State = state;
            RecoveryPointDataStoreType = recoveryPointDataStoreType;
            IsVisible = isVisible;
            RehydrationExpireOn = rehydrationExpireOn;
            RehydrationStatus = rehydrationStatus;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets or sets the created on. </summary>
        public DateTimeOffset? CreatedOn { get; set; }
        /// <summary> Gets or sets the expire on. </summary>
        public DateTimeOffset? ExpireOn { get; set; }
        /// <summary> Gets or sets the recovery point data store id. </summary>
        public Guid? RecoveryPointDataStoreId { get; set; }
        /// <summary> Gets or sets the metadata. </summary>
        public string Metadata { get; set; }
        /// <summary> Gets or sets the state. </summary>
        public string State { get; set; }
        /// <summary> Gets or sets the recovery point data store type. </summary>
        public string RecoveryPointDataStoreType { get; set; }
        /// <summary> Gets or sets the is visible. </summary>
        public bool? IsVisible { get; set; }
        /// <summary> Gets the rehydration expire on. </summary>
        public DateTimeOffset? RehydrationExpireOn { get; }
        /// <summary> Gets the rehydration status. </summary>
        public RecoveryPointDataStoreRehydrationStatus? RehydrationStatus { get; }
    }
}
