// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataProtectionBackup.Models
{
    /// <summary> Item Level target info for restore operation. </summary>
    public partial class RangeBasedItemLevelRestoreCriteria : ItemLevelRestoreCriteria
    {
        /// <summary> Initializes a new instance of <see cref="RangeBasedItemLevelRestoreCriteria"/>. </summary>
        public RangeBasedItemLevelRestoreCriteria()
        {
            ObjectType = "RangeBasedItemLevelRestoreCriteria";
        }

        /// <summary> Initializes a new instance of <see cref="RangeBasedItemLevelRestoreCriteria"/>. </summary>
        /// <param name="objectType"> Type of the specific object - used for deserializing. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="minMatchingValue"> minimum value for range prefix match. </param>
        /// <param name="maxMatchingValue"> maximum value for range prefix match. </param>
        internal RangeBasedItemLevelRestoreCriteria(string objectType, IDictionary<string, BinaryData> serializedAdditionalRawData, string minMatchingValue, string maxMatchingValue) : base(objectType, serializedAdditionalRawData)
        {
            MinMatchingValue = minMatchingValue;
            MaxMatchingValue = maxMatchingValue;
            ObjectType = objectType ?? "RangeBasedItemLevelRestoreCriteria";
        }

        /// <summary> minimum value for range prefix match. </summary>
        public string MinMatchingValue { get; set; }
        /// <summary> maximum value for range prefix match. </summary>
        public string MaxMatchingValue { get; set; }
    }
}
