// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataProtectionBackup.Models
{
    /// <summary> Gets or sets the PV (Persistent Volume) Restore Mode property. This property sets whether volumes needs to be restored. </summary>
    public readonly partial struct PersistentVolumeRestoreMode : IEquatable<PersistentVolumeRestoreMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PersistentVolumeRestoreMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PersistentVolumeRestoreMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string RestoreWithVolumeDataValue = "RestoreWithVolumeData";
        private const string RestoreWithoutVolumeDataValue = "RestoreWithoutVolumeData";

        /// <summary> RestoreWithVolumeData. </summary>
        public static PersistentVolumeRestoreMode RestoreWithVolumeData { get; } = new PersistentVolumeRestoreMode(RestoreWithVolumeDataValue);
        /// <summary> RestoreWithoutVolumeData. </summary>
        public static PersistentVolumeRestoreMode RestoreWithoutVolumeData { get; } = new PersistentVolumeRestoreMode(RestoreWithoutVolumeDataValue);
        /// <summary> Determines if two <see cref="PersistentVolumeRestoreMode"/> values are the same. </summary>
        public static bool operator ==(PersistentVolumeRestoreMode left, PersistentVolumeRestoreMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PersistentVolumeRestoreMode"/> values are not the same. </summary>
        public static bool operator !=(PersistentVolumeRestoreMode left, PersistentVolumeRestoreMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PersistentVolumeRestoreMode"/>. </summary>
        public static implicit operator PersistentVolumeRestoreMode(string value) => new PersistentVolumeRestoreMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PersistentVolumeRestoreMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PersistentVolumeRestoreMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
