// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataProtectionBackup.Models
{
    /// <summary> Monitoring Settings. </summary>
    internal partial class MonitoringSettings
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MonitoringSettings"/>. </summary>
        public MonitoringSettings()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MonitoringSettings"/>. </summary>
        /// <param name="azureMonitorAlertSettings"> Settings for Azure Monitor based alerts. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MonitoringSettings(AzureMonitorAlertSettings azureMonitorAlertSettings, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            AzureMonitorAlertSettings = azureMonitorAlertSettings;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Settings for Azure Monitor based alerts. </summary>
        internal AzureMonitorAlertSettings AzureMonitorAlertSettings { get; set; }
        /// <summary> Gets or sets the alert settings for all job failures. </summary>
        public AzureMonitorAlertsState? AlertSettingsForAllJobFailures
        {
            get => AzureMonitorAlertSettings is null ? default : AzureMonitorAlertSettings.AlertSettingsForAllJobFailures;
            set
            {
                if (AzureMonitorAlertSettings is null)
                    AzureMonitorAlertSettings = new AzureMonitorAlertSettings();
                AzureMonitorAlertSettings.AlertSettingsForAllJobFailures = value;
            }
        }
    }
}
