// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataProtectionBackup.Models
{
    /// <summary> feature support status. </summary>
    public readonly partial struct FeatureSupportStatus : IEquatable<FeatureSupportStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="FeatureSupportStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public FeatureSupportStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InvalidValue = "Invalid";
        private const string NotSupportedValue = "NotSupported";
        private const string AlphaPreviewValue = "AlphaPreview";
        private const string PrivatePreviewValue = "PrivatePreview";
        private const string PublicPreviewValue = "PublicPreview";
        private const string GenerallyAvailableValue = "GenerallyAvailable";

        /// <summary> Invalid. </summary>
        public static FeatureSupportStatus Invalid { get; } = new FeatureSupportStatus(InvalidValue);
        /// <summary> NotSupported. </summary>
        public static FeatureSupportStatus NotSupported { get; } = new FeatureSupportStatus(NotSupportedValue);
        /// <summary> AlphaPreview. </summary>
        public static FeatureSupportStatus AlphaPreview { get; } = new FeatureSupportStatus(AlphaPreviewValue);
        /// <summary> PrivatePreview. </summary>
        public static FeatureSupportStatus PrivatePreview { get; } = new FeatureSupportStatus(PrivatePreviewValue);
        /// <summary> PublicPreview. </summary>
        public static FeatureSupportStatus PublicPreview { get; } = new FeatureSupportStatus(PublicPreviewValue);
        /// <summary> GenerallyAvailable. </summary>
        public static FeatureSupportStatus GenerallyAvailable { get; } = new FeatureSupportStatus(GenerallyAvailableValue);
        /// <summary> Determines if two <see cref="FeatureSupportStatus"/> values are the same. </summary>
        public static bool operator ==(FeatureSupportStatus left, FeatureSupportStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="FeatureSupportStatus"/> values are not the same. </summary>
        public static bool operator !=(FeatureSupportStatus left, FeatureSupportStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="FeatureSupportStatus"/>. </summary>
        public static implicit operator FeatureSupportStatus(string value) => new FeatureSupportStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is FeatureSupportStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(FeatureSupportStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
