// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataProtectionBackup.Models
{
    /// <summary> List of DeletedBackupInstance resources. </summary>
    internal partial class DeletedBackupInstanceResourceList : DppResourceList
    {
        /// <summary> Initializes a new instance of <see cref="DeletedBackupInstanceResourceList"/>. </summary>
        internal DeletedBackupInstanceResourceList()
        {
            Value = new ChangeTrackingList<DeletedDataProtectionBackupInstanceData>();
        }

        /// <summary> Initializes a new instance of <see cref="DeletedBackupInstanceResourceList"/>. </summary>
        /// <param name="nextLink"> The uri to fetch the next page of resources. Call ListNext() fetches next page of resources. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="value"> List of resources. </param>
        internal DeletedBackupInstanceResourceList(string nextLink, IDictionary<string, BinaryData> serializedAdditionalRawData, IReadOnlyList<DeletedDataProtectionBackupInstanceData> value) : base(nextLink, serializedAdditionalRawData)
        {
            Value = value;
        }

        /// <summary> List of resources. </summary>
        public IReadOnlyList<DeletedDataProtectionBackupInstanceData> Value { get; }
    }
}
