// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataProtectionBackup.Models
{
    /// <summary> type of datastore; Operational/Vault/Archive. </summary>
    public readonly partial struct DataStoreType : IEquatable<DataStoreType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataStoreType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataStoreType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OperationalStoreValue = "OperationalStore";
        private const string VaultStoreValue = "VaultStore";
        private const string ArchiveStoreValue = "ArchiveStore";

        /// <summary> OperationalStore. </summary>
        public static DataStoreType OperationalStore { get; } = new DataStoreType(OperationalStoreValue);
        /// <summary> VaultStore. </summary>
        public static DataStoreType VaultStore { get; } = new DataStoreType(VaultStoreValue);
        /// <summary> ArchiveStore. </summary>
        public static DataStoreType ArchiveStore { get; } = new DataStoreType(ArchiveStoreValue);
        /// <summary> Determines if two <see cref="DataStoreType"/> values are the same. </summary>
        public static bool operator ==(DataStoreType left, DataStoreType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataStoreType"/> values are not the same. </summary>
        public static bool operator !=(DataStoreType left, DataStoreType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataStoreType"/>. </summary>
        public static implicit operator DataStoreType(string value) => new DataStoreType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataStoreType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataStoreType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
