// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.DataProtectionBackup.Models
{
    /// <summary> Datasource to be backed up. </summary>
    public partial class DataSourceInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DataSourceInfo"/>. </summary>
        /// <param name="resourceId"> Full ARM ID of the resource. For azure resources, this is ARM ID. For non azure resources, this will be the ID created by backup service via Fabric/Vault. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="resourceId"/> is null. </exception>
        public DataSourceInfo(ResourceIdentifier resourceId)
        {
            Argument.AssertNotNull(resourceId, nameof(resourceId));

            ResourceId = resourceId;
        }

        /// <summary> Initializes a new instance of <see cref="DataSourceInfo"/>. </summary>
        /// <param name="dataSourceType"> DatasourceType of the resource. </param>
        /// <param name="objectType"> Type of Datasource object, used to initialize the right inherited type. </param>
        /// <param name="resourceId"> Full ARM ID of the resource. For azure resources, this is ARM ID. For non azure resources, this will be the ID created by backup service via Fabric/Vault. </param>
        /// <param name="resourceLocation"> Location of datasource. </param>
        /// <param name="resourceName"> Unique identifier of the resource in the context of parent. </param>
        /// <param name="resourceType"> Resource Type of Datasource. </param>
        /// <param name="resourceUriString"> Uri of the resource. </param>
        /// <param name="resourceProperties">
        /// Properties specific to data source
        /// Please note <see cref="BaseResourceProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="DefaultResourceProperties"/>.
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DataSourceInfo(string dataSourceType, string objectType, ResourceIdentifier resourceId, AzureLocation? resourceLocation, string resourceName, ResourceType? resourceType, string resourceUriString, BaseResourceProperties resourceProperties, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DataSourceType = dataSourceType;
            ObjectType = objectType;
            ResourceId = resourceId;
            ResourceLocation = resourceLocation;
            ResourceName = resourceName;
            ResourceType = resourceType;
            ResourceUriString = resourceUriString;
            ResourceProperties = resourceProperties;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="DataSourceInfo"/> for deserialization. </summary>
        internal DataSourceInfo()
        {
        }

        /// <summary> DatasourceType of the resource. </summary>
        public string DataSourceType { get; set; }
        /// <summary> Type of Datasource object, used to initialize the right inherited type. </summary>
        public string ObjectType { get; set; }
        /// <summary> Full ARM ID of the resource. For azure resources, this is ARM ID. For non azure resources, this will be the ID created by backup service via Fabric/Vault. </summary>
        public ResourceIdentifier ResourceId { get; set; }
        /// <summary> Location of datasource. </summary>
        public AzureLocation? ResourceLocation { get; set; }
        /// <summary> Unique identifier of the resource in the context of parent. </summary>
        public string ResourceName { get; set; }
        /// <summary> Resource Type of Datasource. </summary>
        public ResourceType? ResourceType { get; set; }
        /// <summary> Uri of the resource. </summary>
        public string ResourceUriString { get; set; }
        /// <summary>
        /// Properties specific to data source
        /// Please note <see cref="BaseResourceProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="DefaultResourceProperties"/>.
        /// </summary>
        public BaseResourceProperties ResourceProperties { get; set; }
    }
}
