// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataProtectionBackup.Models
{
    /// <summary> The DataProtectionIdentityDetails. </summary>
    public partial class DataProtectionIdentityDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DataProtectionIdentityDetails"/>. </summary>
        public DataProtectionIdentityDetails()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DataProtectionIdentityDetails"/>. </summary>
        /// <param name="useSystemAssignedIdentity"> Specifies if the BI is protected by System Identity. </param>
        /// <param name="userAssignedIdentityArmUri"> ARM URL for User Assigned Identity. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DataProtectionIdentityDetails(bool? useSystemAssignedIdentity, Uri userAssignedIdentityArmUri, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            UseSystemAssignedIdentity = useSystemAssignedIdentity;
            UserAssignedIdentityArmUri = userAssignedIdentityArmUri;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Specifies if the BI is protected by System Identity. </summary>
        public bool? UseSystemAssignedIdentity { get; set; }
        /// <summary> ARM URL for User Assigned Identity. </summary>
        public Uri UserAssignedIdentityArmUri { get; set; }
    }
}
