// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataProtectionBackup.Models
{
    /// <summary> The DataProtectionBackupWeekNumber. </summary>
    public readonly partial struct DataProtectionBackupWeekNumber : IEquatable<DataProtectionBackupWeekNumber>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataProtectionBackupWeekNumber"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataProtectionBackupWeekNumber(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string FirstValue = "First";
        private const string FourthValue = "Fourth";
        private const string LastValue = "Last";
        private const string SecondValue = "Second";
        private const string ThirdValue = "Third";

        /// <summary> First. </summary>
        public static DataProtectionBackupWeekNumber First { get; } = new DataProtectionBackupWeekNumber(FirstValue);
        /// <summary> Fourth. </summary>
        public static DataProtectionBackupWeekNumber Fourth { get; } = new DataProtectionBackupWeekNumber(FourthValue);
        /// <summary> Last. </summary>
        public static DataProtectionBackupWeekNumber Last { get; } = new DataProtectionBackupWeekNumber(LastValue);
        /// <summary> Second. </summary>
        public static DataProtectionBackupWeekNumber Second { get; } = new DataProtectionBackupWeekNumber(SecondValue);
        /// <summary> Third. </summary>
        public static DataProtectionBackupWeekNumber Third { get; } = new DataProtectionBackupWeekNumber(ThirdValue);
        /// <summary> Determines if two <see cref="DataProtectionBackupWeekNumber"/> values are the same. </summary>
        public static bool operator ==(DataProtectionBackupWeekNumber left, DataProtectionBackupWeekNumber right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataProtectionBackupWeekNumber"/> values are not the same. </summary>
        public static bool operator !=(DataProtectionBackupWeekNumber left, DataProtectionBackupWeekNumber right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataProtectionBackupWeekNumber"/>. </summary>
        public static implicit operator DataProtectionBackupWeekNumber(string value) => new DataProtectionBackupWeekNumber(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataProtectionBackupWeekNumber other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataProtectionBackupWeekNumber other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
