// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Core;

namespace Azure.ResourceManager.DataProtectionBackup.Models
{
    /// <summary> Backup Vault. </summary>
    public partial class DataProtectionBackupVaultProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DataProtectionBackupVaultProperties"/>. </summary>
        /// <param name="storageSettings"> Storage Settings. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="storageSettings"/> is null. </exception>
        public DataProtectionBackupVaultProperties(IEnumerable<DataProtectionBackupStorageSetting> storageSettings)
        {
            Argument.AssertNotNull(storageSettings, nameof(storageSettings));

            StorageSettings = storageSettings.ToList();
            ResourceGuardOperationRequests = new ChangeTrackingList<string>();
            ReplicatedRegions = new ChangeTrackingList<AzureLocation>();
        }

        /// <summary> Initializes a new instance of <see cref="DataProtectionBackupVaultProperties"/>. </summary>
        /// <param name="monitoringSettings"> Monitoring Settings. </param>
        /// <param name="provisioningState"> Provisioning state of the BackupVault resource. </param>
        /// <param name="resourceMoveState"> Resource move state for backup vault. </param>
        /// <param name="resourceMoveDetails"> Resource move details for backup vault. </param>
        /// <param name="securitySettings"> Security Settings. </param>
        /// <param name="storageSettings"> Storage Settings. </param>
        /// <param name="isVaultProtectedByResourceGuard"> Is vault protected by resource guard. </param>
        /// <param name="featureSettings"> Feature Settings. </param>
        /// <param name="secureScore"> Secure Score of Backup Vault. </param>
        /// <param name="bcdrSecurityLevel"> Security Level of Backup Vault. </param>
        /// <param name="resourceGuardOperationRequests"> ResourceGuardOperationRequests on which LAC check will be performed. </param>
        /// <param name="replicatedRegions"> List of replicated regions for Backup Vault. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DataProtectionBackupVaultProperties(MonitoringSettings monitoringSettings, DataProtectionBackupProvisioningState? provisioningState, BackupVaultResourceMoveState? resourceMoveState, BackupVaultResourceMoveDetails resourceMoveDetails, BackupVaultSecuritySettings securitySettings, IList<DataProtectionBackupStorageSetting> storageSettings, bool? isVaultProtectedByResourceGuard, BackupVaultFeatureSettings featureSettings, BackupVaultSecureScoreLevel? secureScore, BcdrSecurityLevel? bcdrSecurityLevel, IList<string> resourceGuardOperationRequests, IList<AzureLocation> replicatedRegions, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            MonitoringSettings = monitoringSettings;
            ProvisioningState = provisioningState;
            ResourceMoveState = resourceMoveState;
            ResourceMoveDetails = resourceMoveDetails;
            SecuritySettings = securitySettings;
            StorageSettings = storageSettings;
            IsVaultProtectedByResourceGuard = isVaultProtectedByResourceGuard;
            FeatureSettings = featureSettings;
            SecureScore = secureScore;
            BcdrSecurityLevel = bcdrSecurityLevel;
            ResourceGuardOperationRequests = resourceGuardOperationRequests;
            ReplicatedRegions = replicatedRegions;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="DataProtectionBackupVaultProperties"/> for deserialization. </summary>
        internal DataProtectionBackupVaultProperties()
        {
        }

        /// <summary> Monitoring Settings. </summary>
        internal MonitoringSettings MonitoringSettings { get; set; }
        /// <summary> Gets or sets the alert settings for all job failures. </summary>
        public AzureMonitorAlertsState? AlertSettingsForAllJobFailures
        {
            get => MonitoringSettings is null ? default : MonitoringSettings.AlertSettingsForAllJobFailures;
            set
            {
                if (MonitoringSettings is null)
                    MonitoringSettings = new MonitoringSettings();
                MonitoringSettings.AlertSettingsForAllJobFailures = value;
            }
        }

        /// <summary> Provisioning state of the BackupVault resource. </summary>
        public DataProtectionBackupProvisioningState? ProvisioningState { get; }
        /// <summary> Resource move state for backup vault. </summary>
        public BackupVaultResourceMoveState? ResourceMoveState { get; }
        /// <summary> Resource move details for backup vault. </summary>
        public BackupVaultResourceMoveDetails ResourceMoveDetails { get; }
        /// <summary> Security Settings. </summary>
        public BackupVaultSecuritySettings SecuritySettings { get; set; }
        /// <summary> Storage Settings. </summary>
        public IList<DataProtectionBackupStorageSetting> StorageSettings { get; }
        /// <summary> Feature Settings. </summary>
        public BackupVaultFeatureSettings FeatureSettings { get; set; }
        /// <summary> Secure Score of Backup Vault. </summary>
        public BackupVaultSecureScoreLevel? SecureScore { get; }
        /// <summary> Security Level of Backup Vault. </summary>
        public BcdrSecurityLevel? BcdrSecurityLevel { get; }
        /// <summary> ResourceGuardOperationRequests on which LAC check will be performed. </summary>
        public IList<string> ResourceGuardOperationRequests { get; }
        /// <summary> List of replicated regions for Backup Vault. </summary>
        public IList<AzureLocation> ReplicatedRegions { get; }
    }
}
