// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataProtectionBackup.Models
{
    /// <summary> Backup Vault Contract for Patch Backup Vault API. </summary>
    public partial class DataProtectionBackupVaultPatchProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DataProtectionBackupVaultPatchProperties"/>. </summary>
        public DataProtectionBackupVaultPatchProperties()
        {
            ResourceGuardOperationRequests = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="DataProtectionBackupVaultPatchProperties"/>. </summary>
        /// <param name="monitoringSettings"> Monitoring Settings. </param>
        /// <param name="securitySettings"> Security Settings. </param>
        /// <param name="featureSettings"> Feature Settings. </param>
        /// <param name="resourceGuardOperationRequests"> ResourceGuardOperationRequests on which LAC check will be performed. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DataProtectionBackupVaultPatchProperties(MonitoringSettings monitoringSettings, BackupVaultSecuritySettings securitySettings, BackupVaultFeatureSettings featureSettings, IList<string> resourceGuardOperationRequests, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            MonitoringSettings = monitoringSettings;
            SecuritySettings = securitySettings;
            FeatureSettings = featureSettings;
            ResourceGuardOperationRequests = resourceGuardOperationRequests;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Monitoring Settings. </summary>
        internal MonitoringSettings MonitoringSettings { get; set; }
        /// <summary> Gets or sets the alert settings for all job failures. </summary>
        public AzureMonitorAlertsState? AlertSettingsForAllJobFailures
        {
            get => MonitoringSettings is null ? default : MonitoringSettings.AlertSettingsForAllJobFailures;
            set
            {
                if (MonitoringSettings is null)
                    MonitoringSettings = new MonitoringSettings();
                MonitoringSettings.AlertSettingsForAllJobFailures = value;
            }
        }

        /// <summary> Security Settings. </summary>
        public BackupVaultSecuritySettings SecuritySettings { get; set; }
        /// <summary> Feature Settings. </summary>
        public BackupVaultFeatureSettings FeatureSettings { get; set; }
        /// <summary> ResourceGuardOperationRequests on which LAC check will be performed. </summary>
        public IList<string> ResourceGuardOperationRequests { get; }
    }
}
