// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.DataProtectionBackup.Models
{
    /// <summary> Schedule for backup. </summary>
    public partial class DataProtectionBackupSchedule
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DataProtectionBackupSchedule"/>. </summary>
        /// <param name="repeatingTimeIntervals"> ISO 8601 repeating time interval format. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="repeatingTimeIntervals"/> is null. </exception>
        public DataProtectionBackupSchedule(IEnumerable<string> repeatingTimeIntervals)
        {
            Argument.AssertNotNull(repeatingTimeIntervals, nameof(repeatingTimeIntervals));

            RepeatingTimeIntervals = repeatingTimeIntervals.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="DataProtectionBackupSchedule"/>. </summary>
        /// <param name="repeatingTimeIntervals"> ISO 8601 repeating time interval format. </param>
        /// <param name="timeZone"> Time zone for a schedule. Example: Pacific Standard Time. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DataProtectionBackupSchedule(IList<string> repeatingTimeIntervals, string timeZone, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            RepeatingTimeIntervals = repeatingTimeIntervals;
            TimeZone = timeZone;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="DataProtectionBackupSchedule"/> for deserialization. </summary>
        internal DataProtectionBackupSchedule()
        {
        }

        /// <summary> ISO 8601 repeating time interval format. </summary>
        public IList<string> RepeatingTimeIntervals { get; }
        /// <summary> Time zone for a schedule. Example: Pacific Standard Time. </summary>
        public string TimeZone { get; set; }
    }
}
