// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataProtectionBackup.Models
{
    /// <summary> Azure backup rule. </summary>
    public partial class DataProtectionBackupRule : DataProtectionBasePolicyRule
    {
        /// <summary> Initializes a new instance of <see cref="DataProtectionBackupRule"/>. </summary>
        /// <param name="name"></param>
        /// <param name="dataStore"> DataStoreInfo base. </param>
        /// <param name="trigger">
        /// Trigger context
        /// Please note <see cref="DataProtectionBackupTriggerContext"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AdhocBasedBackupTriggerContext"/> and <see cref="ScheduleBasedBackupTriggerContext"/>.
        /// </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/>, <paramref name="dataStore"/> or <paramref name="trigger"/> is null. </exception>
        public DataProtectionBackupRule(string name, DataStoreInfoBase dataStore, DataProtectionBackupTriggerContext trigger) : base(name)
        {
            Argument.AssertNotNull(name, nameof(name));
            Argument.AssertNotNull(dataStore, nameof(dataStore));
            Argument.AssertNotNull(trigger, nameof(trigger));

            DataStore = dataStore;
            Trigger = trigger;
            ObjectType = "AzureBackupRule";
        }

        /// <summary> Initializes a new instance of <see cref="DataProtectionBackupRule"/>. </summary>
        /// <param name="name"></param>
        /// <param name="objectType"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="backupParameters">
        /// BackupParameters base
        /// Please note <see cref="DataProtectionBackupSettingsBase"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="DataProtectionBackupSettings"/>.
        /// </param>
        /// <param name="dataStore"> DataStoreInfo base. </param>
        /// <param name="trigger">
        /// Trigger context
        /// Please note <see cref="DataProtectionBackupTriggerContext"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AdhocBasedBackupTriggerContext"/> and <see cref="ScheduleBasedBackupTriggerContext"/>.
        /// </param>
        internal DataProtectionBackupRule(string name, string objectType, IDictionary<string, BinaryData> serializedAdditionalRawData, DataProtectionBackupSettingsBase backupParameters, DataStoreInfoBase dataStore, DataProtectionBackupTriggerContext trigger) : base(name, objectType, serializedAdditionalRawData)
        {
            BackupParameters = backupParameters;
            DataStore = dataStore;
            Trigger = trigger;
            ObjectType = objectType ?? "AzureBackupRule";
        }

        /// <summary> Initializes a new instance of <see cref="DataProtectionBackupRule"/> for deserialization. </summary>
        internal DataProtectionBackupRule()
        {
        }

        /// <summary>
        /// BackupParameters base
        /// Please note <see cref="DataProtectionBackupSettingsBase"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="DataProtectionBackupSettings"/>.
        /// </summary>
        public DataProtectionBackupSettingsBase BackupParameters { get; set; }
        /// <summary> DataStoreInfo base. </summary>
        public DataStoreInfoBase DataStore { get; set; }
        /// <summary>
        /// Trigger context
        /// Please note <see cref="DataProtectionBackupTriggerContext"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AdhocBasedBackupTriggerContext"/> and <see cref="ScheduleBasedBackupTriggerContext"/>.
        /// </summary>
        public DataProtectionBackupTriggerContext Trigger { get; set; }
    }
}
