// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataProtectionBackup.Models
{
    /// <summary> Specifies recovery point completeness. Partial (i.e., only some of the intended items were backed up), or Completed (i.e., ALL intended items were backed up). </summary>
    public readonly partial struct DataProtectionBackupRecoveryPointCompletionState : IEquatable<DataProtectionBackupRecoveryPointCompletionState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataProtectionBackupRecoveryPointCompletionState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataProtectionBackupRecoveryPointCompletionState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CompletedValue = "Completed";
        private const string PartialValue = "Partial";

        /// <summary> Completed. </summary>
        public static DataProtectionBackupRecoveryPointCompletionState Completed { get; } = new DataProtectionBackupRecoveryPointCompletionState(CompletedValue);
        /// <summary> Partial. </summary>
        public static DataProtectionBackupRecoveryPointCompletionState Partial { get; } = new DataProtectionBackupRecoveryPointCompletionState(PartialValue);
        /// <summary> Determines if two <see cref="DataProtectionBackupRecoveryPointCompletionState"/> values are the same. </summary>
        public static bool operator ==(DataProtectionBackupRecoveryPointCompletionState left, DataProtectionBackupRecoveryPointCompletionState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataProtectionBackupRecoveryPointCompletionState"/> values are not the same. </summary>
        public static bool operator !=(DataProtectionBackupRecoveryPointCompletionState left, DataProtectionBackupRecoveryPointCompletionState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataProtectionBackupRecoveryPointCompletionState"/>. </summary>
        public static implicit operator DataProtectionBackupRecoveryPointCompletionState(string value) => new DataProtectionBackupRecoveryPointCompletionState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataProtectionBackupRecoveryPointCompletionState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataProtectionBackupRecoveryPointCompletionState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
