// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataProtectionBackup.Models
{
    /// <summary> Provisioning state of the BackupVault resource. </summary>
    public readonly partial struct DataProtectionBackupProvisioningState : IEquatable<DataProtectionBackupProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataProtectionBackupProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataProtectionBackupProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string FailedValue = "Failed";
        private const string ProvisioningValue = "Provisioning";
        private const string SucceededValue = "Succeeded";
        private const string UnknownValue = "Unknown";
        private const string UpdatingValue = "Updating";

        /// <summary> Failed. </summary>
        public static DataProtectionBackupProvisioningState Failed { get; } = new DataProtectionBackupProvisioningState(FailedValue);
        /// <summary> Provisioning. </summary>
        public static DataProtectionBackupProvisioningState Provisioning { get; } = new DataProtectionBackupProvisioningState(ProvisioningValue);
        /// <summary> Succeeded. </summary>
        public static DataProtectionBackupProvisioningState Succeeded { get; } = new DataProtectionBackupProvisioningState(SucceededValue);
        /// <summary> Unknown. </summary>
        public static DataProtectionBackupProvisioningState Unknown { get; } = new DataProtectionBackupProvisioningState(UnknownValue);
        /// <summary> Updating. </summary>
        public static DataProtectionBackupProvisioningState Updating { get; } = new DataProtectionBackupProvisioningState(UpdatingValue);
        /// <summary> Determines if two <see cref="DataProtectionBackupProvisioningState"/> values are the same. </summary>
        public static bool operator ==(DataProtectionBackupProvisioningState left, DataProtectionBackupProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataProtectionBackupProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(DataProtectionBackupProvisioningState left, DataProtectionBackupProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataProtectionBackupProvisioningState"/>. </summary>
        public static implicit operator DataProtectionBackupProvisioningState(string value) => new DataProtectionBackupProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataProtectionBackupProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataProtectionBackupProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
