// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.DataProtectionBackup.Models
{
    /// <summary>
    /// BackupPolicy base
    /// Please note <see cref="DataProtectionBackupPolicyPropertiesBase"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
    /// The available derived classes include <see cref="RuleBasedBackupPolicy"/>.
    /// </summary>
    public abstract partial class DataProtectionBackupPolicyPropertiesBase
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private protected IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DataProtectionBackupPolicyPropertiesBase"/>. </summary>
        /// <param name="dataSourceTypes"> Type of datasource for the backup management. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="dataSourceTypes"/> is null. </exception>
        protected DataProtectionBackupPolicyPropertiesBase(IEnumerable<string> dataSourceTypes)
        {
            Argument.AssertNotNull(dataSourceTypes, nameof(dataSourceTypes));

            DataSourceTypes = dataSourceTypes.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="DataProtectionBackupPolicyPropertiesBase"/>. </summary>
        /// <param name="dataSourceTypes"> Type of datasource for the backup management. </param>
        /// <param name="objectType"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DataProtectionBackupPolicyPropertiesBase(IList<string> dataSourceTypes, string objectType, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DataSourceTypes = dataSourceTypes;
            ObjectType = objectType;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="DataProtectionBackupPolicyPropertiesBase"/> for deserialization. </summary>
        internal DataProtectionBackupPolicyPropertiesBase()
        {
        }

        /// <summary> Type of datasource for the backup management. </summary>
        public IList<string> DataSourceTypes { get; }
        /// <summary> Gets or sets the object type. </summary>
        internal string ObjectType { get; set; }
    }
}
