// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataProtectionBackup.Models
{
    /// <summary> The DataProtectionBackupMonth. </summary>
    public readonly partial struct DataProtectionBackupMonth : IEquatable<DataProtectionBackupMonth>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataProtectionBackupMonth"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataProtectionBackupMonth(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AprilValue = "April";
        private const string AugustValue = "August";
        private const string DecemberValue = "December";
        private const string FebruaryValue = "February";
        private const string JanuaryValue = "January";
        private const string JulyValue = "July";
        private const string JuneValue = "June";
        private const string MarchValue = "March";
        private const string MayValue = "May";
        private const string NovemberValue = "November";
        private const string OctoberValue = "October";
        private const string SeptemberValue = "September";

        /// <summary> April. </summary>
        public static DataProtectionBackupMonth April { get; } = new DataProtectionBackupMonth(AprilValue);
        /// <summary> August. </summary>
        public static DataProtectionBackupMonth August { get; } = new DataProtectionBackupMonth(AugustValue);
        /// <summary> December. </summary>
        public static DataProtectionBackupMonth December { get; } = new DataProtectionBackupMonth(DecemberValue);
        /// <summary> February. </summary>
        public static DataProtectionBackupMonth February { get; } = new DataProtectionBackupMonth(FebruaryValue);
        /// <summary> January. </summary>
        public static DataProtectionBackupMonth January { get; } = new DataProtectionBackupMonth(JanuaryValue);
        /// <summary> July. </summary>
        public static DataProtectionBackupMonth July { get; } = new DataProtectionBackupMonth(JulyValue);
        /// <summary> June. </summary>
        public static DataProtectionBackupMonth June { get; } = new DataProtectionBackupMonth(JuneValue);
        /// <summary> March. </summary>
        public static DataProtectionBackupMonth March { get; } = new DataProtectionBackupMonth(MarchValue);
        /// <summary> May. </summary>
        public static DataProtectionBackupMonth May { get; } = new DataProtectionBackupMonth(MayValue);
        /// <summary> November. </summary>
        public static DataProtectionBackupMonth November { get; } = new DataProtectionBackupMonth(NovemberValue);
        /// <summary> October. </summary>
        public static DataProtectionBackupMonth October { get; } = new DataProtectionBackupMonth(OctoberValue);
        /// <summary> September. </summary>
        public static DataProtectionBackupMonth September { get; } = new DataProtectionBackupMonth(SeptemberValue);
        /// <summary> Determines if two <see cref="DataProtectionBackupMonth"/> values are the same. </summary>
        public static bool operator ==(DataProtectionBackupMonth left, DataProtectionBackupMonth right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataProtectionBackupMonth"/> values are not the same. </summary>
        public static bool operator !=(DataProtectionBackupMonth left, DataProtectionBackupMonth right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataProtectionBackupMonth"/>. </summary>
        public static implicit operator DataProtectionBackupMonth(string value) => new DataProtectionBackupMonth(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataProtectionBackupMonth other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataProtectionBackupMonth other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
