// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataProtectionBackup.Models
{
    /// <summary> The DataProtectionBackupDayOfWeek. </summary>
    public readonly partial struct DataProtectionBackupDayOfWeek : IEquatable<DataProtectionBackupDayOfWeek>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataProtectionBackupDayOfWeek"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataProtectionBackupDayOfWeek(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string FridayValue = "Friday";
        private const string MondayValue = "Monday";
        private const string SaturdayValue = "Saturday";
        private const string SundayValue = "Sunday";
        private const string ThursdayValue = "Thursday";
        private const string TuesdayValue = "Tuesday";
        private const string WednesdayValue = "Wednesday";

        /// <summary> Friday. </summary>
        public static DataProtectionBackupDayOfWeek Friday { get; } = new DataProtectionBackupDayOfWeek(FridayValue);
        /// <summary> Monday. </summary>
        public static DataProtectionBackupDayOfWeek Monday { get; } = new DataProtectionBackupDayOfWeek(MondayValue);
        /// <summary> Saturday. </summary>
        public static DataProtectionBackupDayOfWeek Saturday { get; } = new DataProtectionBackupDayOfWeek(SaturdayValue);
        /// <summary> Sunday. </summary>
        public static DataProtectionBackupDayOfWeek Sunday { get; } = new DataProtectionBackupDayOfWeek(SundayValue);
        /// <summary> Thursday. </summary>
        public static DataProtectionBackupDayOfWeek Thursday { get; } = new DataProtectionBackupDayOfWeek(ThursdayValue);
        /// <summary> Tuesday. </summary>
        public static DataProtectionBackupDayOfWeek Tuesday { get; } = new DataProtectionBackupDayOfWeek(TuesdayValue);
        /// <summary> Wednesday. </summary>
        public static DataProtectionBackupDayOfWeek Wednesday { get; } = new DataProtectionBackupDayOfWeek(WednesdayValue);
        /// <summary> Determines if two <see cref="DataProtectionBackupDayOfWeek"/> values are the same. </summary>
        public static bool operator ==(DataProtectionBackupDayOfWeek left, DataProtectionBackupDayOfWeek right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataProtectionBackupDayOfWeek"/> values are not the same. </summary>
        public static bool operator !=(DataProtectionBackupDayOfWeek left, DataProtectionBackupDayOfWeek right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataProtectionBackupDayOfWeek"/>. </summary>
        public static implicit operator DataProtectionBackupDayOfWeek(string value) => new DataProtectionBackupDayOfWeek(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataProtectionBackupDayOfWeek other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataProtectionBackupDayOfWeek other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
