// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataProtectionBackup.Models
{
    /// <summary> CrossSubscriptionRestore state. </summary>
    public readonly partial struct DataProtectionBackupCrossSubscriptionRestoreState : IEquatable<DataProtectionBackupCrossSubscriptionRestoreState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataProtectionBackupCrossSubscriptionRestoreState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataProtectionBackupCrossSubscriptionRestoreState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DisabledValue = "Disabled";
        private const string PermanentlyDisabledValue = "PermanentlyDisabled";
        private const string EnabledValue = "Enabled";

        /// <summary> Disabled. </summary>
        public static DataProtectionBackupCrossSubscriptionRestoreState Disabled { get; } = new DataProtectionBackupCrossSubscriptionRestoreState(DisabledValue);
        /// <summary> PermanentlyDisabled. </summary>
        public static DataProtectionBackupCrossSubscriptionRestoreState PermanentlyDisabled { get; } = new DataProtectionBackupCrossSubscriptionRestoreState(PermanentlyDisabledValue);
        /// <summary> Enabled. </summary>
        public static DataProtectionBackupCrossSubscriptionRestoreState Enabled { get; } = new DataProtectionBackupCrossSubscriptionRestoreState(EnabledValue);
        /// <summary> Determines if two <see cref="DataProtectionBackupCrossSubscriptionRestoreState"/> values are the same. </summary>
        public static bool operator ==(DataProtectionBackupCrossSubscriptionRestoreState left, DataProtectionBackupCrossSubscriptionRestoreState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataProtectionBackupCrossSubscriptionRestoreState"/> values are not the same. </summary>
        public static bool operator !=(DataProtectionBackupCrossSubscriptionRestoreState left, DataProtectionBackupCrossSubscriptionRestoreState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataProtectionBackupCrossSubscriptionRestoreState"/>. </summary>
        public static implicit operator DataProtectionBackupCrossSubscriptionRestoreState(string value) => new DataProtectionBackupCrossSubscriptionRestoreState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataProtectionBackupCrossSubscriptionRestoreState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataProtectionBackupCrossSubscriptionRestoreState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
