// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataProtectionBackup.Models
{
    /// <summary> Security Level of Backup Vault. </summary>
    public readonly partial struct BcdrSecurityLevel : IEquatable<BcdrSecurityLevel>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BcdrSecurityLevel"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BcdrSecurityLevel(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PoorValue = "Poor";
        private const string FairValue = "Fair";
        private const string GoodValue = "Good";
        private const string ExcellentValue = "Excellent";
        private const string NotSupportedValue = "NotSupported";

        /// <summary> Poor. </summary>
        public static BcdrSecurityLevel Poor { get; } = new BcdrSecurityLevel(PoorValue);
        /// <summary> Fair. </summary>
        public static BcdrSecurityLevel Fair { get; } = new BcdrSecurityLevel(FairValue);
        /// <summary> Good. </summary>
        public static BcdrSecurityLevel Good { get; } = new BcdrSecurityLevel(GoodValue);
        /// <summary> Excellent. </summary>
        public static BcdrSecurityLevel Excellent { get; } = new BcdrSecurityLevel(ExcellentValue);
        /// <summary> NotSupported. </summary>
        public static BcdrSecurityLevel NotSupported { get; } = new BcdrSecurityLevel(NotSupportedValue);
        /// <summary> Determines if two <see cref="BcdrSecurityLevel"/> values are the same. </summary>
        public static bool operator ==(BcdrSecurityLevel left, BcdrSecurityLevel right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BcdrSecurityLevel"/> values are not the same. </summary>
        public static bool operator !=(BcdrSecurityLevel left, BcdrSecurityLevel right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BcdrSecurityLevel"/>. </summary>
        public static implicit operator BcdrSecurityLevel(string value) => new BcdrSecurityLevel(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BcdrSecurityLevel other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BcdrSecurityLevel other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
