// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataProtectionBackup.Models
{
    /// <summary> Soft delete related settings. </summary>
    public partial class BackupVaultSoftDeleteSettings
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BackupVaultSoftDeleteSettings"/>. </summary>
        public BackupVaultSoftDeleteSettings()
        {
        }

        /// <summary> Initializes a new instance of <see cref="BackupVaultSoftDeleteSettings"/>. </summary>
        /// <param name="state"> State of soft delete. </param>
        /// <param name="retentionDurationInDays"> Soft delete retention duration. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BackupVaultSoftDeleteSettings(BackupVaultSoftDeleteState? state, double? retentionDurationInDays, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            State = state;
            RetentionDurationInDays = retentionDurationInDays;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> State of soft delete. </summary>
        public BackupVaultSoftDeleteState? State { get; set; }
        /// <summary> Soft delete retention duration. </summary>
        public double? RetentionDurationInDays { get; set; }
    }
}
