// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.DataProtectionBackup.Models
{
    public partial class BackupVaultResourceMoveDetails : IUtf8JsonSerializable, IJsonModel<BackupVaultResourceMoveDetails>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<BackupVaultResourceMoveDetails>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<BackupVaultResourceMoveDetails>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BackupVaultResourceMoveDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(BackupVaultResourceMoveDetails)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(OperationId))
            {
                writer.WritePropertyName("operationId"u8);
                writer.WriteStringValue(OperationId);
            }
            if (Optional.IsDefined(StartOn))
            {
                writer.WritePropertyName("startTimeUtc"u8);
                writer.WriteStringValue(StartOn.Value, "O");
            }
            if (Optional.IsDefined(CompleteOn))
            {
                writer.WritePropertyName("completionTimeUtc"u8);
                writer.WriteStringValue(CompleteOn.Value, "O");
            }
            if (Optional.IsDefined(SourceResourcePath))
            {
                writer.WritePropertyName("sourceResourcePath"u8);
                writer.WriteStringValue(SourceResourcePath);
            }
            if (Optional.IsDefined(TargetResourcePath))
            {
                writer.WritePropertyName("targetResourcePath"u8);
                writer.WriteStringValue(TargetResourcePath);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        BackupVaultResourceMoveDetails IJsonModel<BackupVaultResourceMoveDetails>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BackupVaultResourceMoveDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(BackupVaultResourceMoveDetails)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeBackupVaultResourceMoveDetails(document.RootElement, options);
        }

        internal static BackupVaultResourceMoveDetails DeserializeBackupVaultResourceMoveDetails(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string operationId = default;
            DateTimeOffset? startTimeUtc = default;
            DateTimeOffset? completionTimeUtc = default;
            string sourceResourcePath = default;
            string targetResourcePath = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("operationId"u8))
                {
                    operationId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("startTimeUtc"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    startTimeUtc = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("completionTimeUtc"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    completionTimeUtc = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("sourceResourcePath"u8))
                {
                    sourceResourcePath = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("targetResourcePath"u8))
                {
                    targetResourcePath = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new BackupVaultResourceMoveDetails(
                operationId,
                startTimeUtc,
                completionTimeUtc,
                sourceResourcePath,
                targetResourcePath,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<BackupVaultResourceMoveDetails>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BackupVaultResourceMoveDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(BackupVaultResourceMoveDetails)} does not support writing '{options.Format}' format.");
            }
        }

        BackupVaultResourceMoveDetails IPersistableModel<BackupVaultResourceMoveDetails>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BackupVaultResourceMoveDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeBackupVaultResourceMoveDetails(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(BackupVaultResourceMoveDetails)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<BackupVaultResourceMoveDetails>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
