// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataProtectionBackup.Models
{
    /// <summary> Enabling/Disabling the Double Encryption state. </summary>
    public readonly partial struct BackupVaultInfrastructureEncryptionState : IEquatable<BackupVaultInfrastructureEncryptionState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BackupVaultInfrastructureEncryptionState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BackupVaultInfrastructureEncryptionState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Enabled. </summary>
        public static BackupVaultInfrastructureEncryptionState Enabled { get; } = new BackupVaultInfrastructureEncryptionState(EnabledValue);
        /// <summary> Disabled. </summary>
        public static BackupVaultInfrastructureEncryptionState Disabled { get; } = new BackupVaultInfrastructureEncryptionState(DisabledValue);
        /// <summary> Determines if two <see cref="BackupVaultInfrastructureEncryptionState"/> values are the same. </summary>
        public static bool operator ==(BackupVaultInfrastructureEncryptionState left, BackupVaultInfrastructureEncryptionState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BackupVaultInfrastructureEncryptionState"/> values are not the same. </summary>
        public static bool operator !=(BackupVaultInfrastructureEncryptionState left, BackupVaultInfrastructureEncryptionState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BackupVaultInfrastructureEncryptionState"/>. </summary>
        public static implicit operator BackupVaultInfrastructureEncryptionState(string value) => new BackupVaultInfrastructureEncryptionState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BackupVaultInfrastructureEncryptionState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BackupVaultInfrastructureEncryptionState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
