// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataProtectionBackup.Models
{
    /// <summary> Immutability state. </summary>
    public readonly partial struct BackupVaultImmutabilityState : IEquatable<BackupVaultImmutabilityState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BackupVaultImmutabilityState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BackupVaultImmutabilityState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DisabledValue = "Disabled";
        private const string UnlockedValue = "Unlocked";
        private const string LockedValue = "Locked";

        /// <summary> Disabled. </summary>
        public static BackupVaultImmutabilityState Disabled { get; } = new BackupVaultImmutabilityState(DisabledValue);
        /// <summary> Unlocked. </summary>
        public static BackupVaultImmutabilityState Unlocked { get; } = new BackupVaultImmutabilityState(UnlockedValue);
        /// <summary> Locked. </summary>
        public static BackupVaultImmutabilityState Locked { get; } = new BackupVaultImmutabilityState(LockedValue);
        /// <summary> Determines if two <see cref="BackupVaultImmutabilityState"/> values are the same. </summary>
        public static bool operator ==(BackupVaultImmutabilityState left, BackupVaultImmutabilityState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BackupVaultImmutabilityState"/> values are not the same. </summary>
        public static bool operator !=(BackupVaultImmutabilityState left, BackupVaultImmutabilityState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BackupVaultImmutabilityState"/>. </summary>
        public static implicit operator BackupVaultImmutabilityState(string value) => new BackupVaultImmutabilityState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BackupVaultImmutabilityState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BackupVaultImmutabilityState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
