// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataProtectionBackup.Models
{
    /// <summary> Class containing feature settings of vault. </summary>
    public partial class BackupVaultFeatureSettings
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BackupVaultFeatureSettings"/>. </summary>
        public BackupVaultFeatureSettings()
        {
        }

        /// <summary> Initializes a new instance of <see cref="BackupVaultFeatureSettings"/>. </summary>
        /// <param name="crossSubscriptionRestoreSettings"> CrossSubscriptionRestore Settings. </param>
        /// <param name="crossRegionRestoreSettings"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BackupVaultFeatureSettings(CrossSubscriptionRestoreSettings crossSubscriptionRestoreSettings, CrossRegionRestoreSettings crossRegionRestoreSettings, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            CrossSubscriptionRestoreSettings = crossSubscriptionRestoreSettings;
            CrossRegionRestoreSettings = crossRegionRestoreSettings;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> CrossSubscriptionRestore Settings. </summary>
        internal CrossSubscriptionRestoreSettings CrossSubscriptionRestoreSettings { get; set; }
        /// <summary> CrossSubscriptionRestore state. </summary>
        public DataProtectionBackupCrossSubscriptionRestoreState? CrossSubscriptionRestoreState
        {
            get => CrossSubscriptionRestoreSettings is null ? default : CrossSubscriptionRestoreSettings.State;
            set
            {
                if (CrossSubscriptionRestoreSettings is null)
                    CrossSubscriptionRestoreSettings = new CrossSubscriptionRestoreSettings();
                CrossSubscriptionRestoreSettings.State = value;
            }
        }

        /// <summary> Gets or sets the cross region restore settings. </summary>
        internal CrossRegionRestoreSettings CrossRegionRestoreSettings { get; set; }
        /// <summary> CrossRegionRestore state. </summary>
        public CrossRegionRestoreState? CrossRegionRestoreState
        {
            get => CrossRegionRestoreSettings is null ? default : CrossRegionRestoreSettings.State;
            set
            {
                if (CrossRegionRestoreSettings is null)
                    CrossRegionRestoreSettings = new CrossRegionRestoreSettings();
                CrossRegionRestoreSettings.State = value;
            }
        }
    }
}
