// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataProtectionBackup.Models
{
    /// <summary> The identity type. 'SystemAssigned' and 'UserAssigned' are mutually exclusive. 'SystemAssigned' will use implicitly created managed identity. </summary>
    public readonly partial struct BackupVaultCmkKekIdentityType : IEquatable<BackupVaultCmkKekIdentityType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BackupVaultCmkKekIdentityType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BackupVaultCmkKekIdentityType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SystemAssignedValue = "SystemAssigned";
        private const string UserAssignedValue = "UserAssigned";

        /// <summary> SystemAssigned. </summary>
        public static BackupVaultCmkKekIdentityType SystemAssigned { get; } = new BackupVaultCmkKekIdentityType(SystemAssignedValue);
        /// <summary> UserAssigned. </summary>
        public static BackupVaultCmkKekIdentityType UserAssigned { get; } = new BackupVaultCmkKekIdentityType(UserAssignedValue);
        /// <summary> Determines if two <see cref="BackupVaultCmkKekIdentityType"/> values are the same. </summary>
        public static bool operator ==(BackupVaultCmkKekIdentityType left, BackupVaultCmkKekIdentityType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BackupVaultCmkKekIdentityType"/> values are not the same. </summary>
        public static bool operator !=(BackupVaultCmkKekIdentityType left, BackupVaultCmkKekIdentityType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BackupVaultCmkKekIdentityType"/>. </summary>
        public static implicit operator BackupVaultCmkKekIdentityType(string value) => new BackupVaultCmkKekIdentityType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BackupVaultCmkKekIdentityType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BackupVaultCmkKekIdentityType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
