// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataProtectionBackup.Models
{
    /// <summary> backup support feature type. </summary>
    public readonly partial struct BackupSupportedFeatureType : IEquatable<BackupSupportedFeatureType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BackupSupportedFeatureType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BackupSupportedFeatureType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InvalidValue = "Invalid";
        private const string DataSourceTypeValue = "DataSourceType";

        /// <summary> Invalid. </summary>
        public static BackupSupportedFeatureType Invalid { get; } = new BackupSupportedFeatureType(InvalidValue);
        /// <summary> DataSourceType. </summary>
        public static BackupSupportedFeatureType DataSourceType { get; } = new BackupSupportedFeatureType(DataSourceTypeValue);
        /// <summary> Determines if two <see cref="BackupSupportedFeatureType"/> values are the same. </summary>
        public static bool operator ==(BackupSupportedFeatureType left, BackupSupportedFeatureType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BackupSupportedFeatureType"/> values are not the same. </summary>
        public static bool operator !=(BackupSupportedFeatureType left, BackupSupportedFeatureType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BackupSupportedFeatureType"/>. </summary>
        public static implicit operator BackupSupportedFeatureType(string value) => new BackupSupportedFeatureType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BackupSupportedFeatureType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BackupSupportedFeatureType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
