// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataProtectionBackup.Models
{
    /// <summary> Elements class for feature request. </summary>
    public partial class BackupSupportedFeature
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BackupSupportedFeature"/>. </summary>
        internal BackupSupportedFeature()
        {
            ExposureControlledFeatures = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="BackupSupportedFeature"/>. </summary>
        /// <param name="featureName"> support feature type. </param>
        /// <param name="supportStatus"> feature support status. </param>
        /// <param name="exposureControlledFeatures"> support feature type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BackupSupportedFeature(string featureName, FeatureSupportStatus? supportStatus, IReadOnlyList<string> exposureControlledFeatures, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            FeatureName = featureName;
            SupportStatus = supportStatus;
            ExposureControlledFeatures = exposureControlledFeatures;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> support feature type. </summary>
        public string FeatureName { get; }
        /// <summary> feature support status. </summary>
        public FeatureSupportStatus? SupportStatus { get; }
        /// <summary> support feature type. </summary>
        public IReadOnlyList<string> ExposureControlledFeatures { get; }
    }
}
