// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.DataProtectionBackup.Models
{
    /// <summary> AzureBackup Restore with Rehydration Request. </summary>
    public partial class BackupRestoreWithRehydrationContent : BackupRecoveryPointBasedRestoreContent
    {
        /// <summary> Initializes a new instance of <see cref="BackupRestoreWithRehydrationContent"/>. </summary>
        /// <param name="restoreTargetInfo">
        /// Gets or sets the restore target information.
        /// Please note <see cref="RestoreTargetInfoBase"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ItemLevelRestoreTargetInfo"/>, <see cref="RestoreFilesTargetInfo"/> and <see cref="RestoreTargetInfo"/>.
        /// </param>
        /// <param name="sourceDataStoreType"> Gets or sets the type of the source data store. </param>
        /// <param name="recoveryPointId"></param>
        /// <param name="rehydrationPriority"> Priority to be used for rehydration. Values High or Standard. </param>
        /// <param name="rehydrationRetentionDuration"> Retention duration in ISO 8601 format i.e P10D . </param>
        /// <exception cref="ArgumentNullException"> <paramref name="restoreTargetInfo"/> or <paramref name="recoveryPointId"/> is null. </exception>
        public BackupRestoreWithRehydrationContent(RestoreTargetInfoBase restoreTargetInfo, SourceDataStoreType sourceDataStoreType, string recoveryPointId, BackupRehydrationPriority rehydrationPriority, TimeSpan rehydrationRetentionDuration) : base(restoreTargetInfo, sourceDataStoreType, recoveryPointId)
        {
            Argument.AssertNotNull(restoreTargetInfo, nameof(restoreTargetInfo));
            Argument.AssertNotNull(recoveryPointId, nameof(recoveryPointId));

            RehydrationPriority = rehydrationPriority;
            RehydrationRetentionDuration = rehydrationRetentionDuration;
            ObjectType = "AzureBackupRestoreWithRehydrationRequest";
        }

        /// <summary> Initializes a new instance of <see cref="BackupRestoreWithRehydrationContent"/>. </summary>
        /// <param name="objectType"></param>
        /// <param name="restoreTargetInfo">
        /// Gets or sets the restore target information.
        /// Please note <see cref="RestoreTargetInfoBase"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ItemLevelRestoreTargetInfo"/>, <see cref="RestoreFilesTargetInfo"/> and <see cref="RestoreTargetInfo"/>.
        /// </param>
        /// <param name="sourceDataStoreType"> Gets or sets the type of the source data store. </param>
        /// <param name="sourceResourceId"> Fully qualified Azure Resource Manager ID of the datasource which is being recovered. </param>
        /// <param name="resourceGuardOperationRequests"> ResourceGuardOperationRequests on which LAC check will be performed. </param>
        /// <param name="identityDetails">
        /// Contains information of the Identity Details for the BI.
        /// If it is null, default will be considered as System Assigned.
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="recoveryPointId"></param>
        /// <param name="rehydrationPriority"> Priority to be used for rehydration. Values High or Standard. </param>
        /// <param name="rehydrationRetentionDuration"> Retention duration in ISO 8601 format i.e P10D . </param>
        internal BackupRestoreWithRehydrationContent(string objectType, RestoreTargetInfoBase restoreTargetInfo, SourceDataStoreType sourceDataStoreType, ResourceIdentifier sourceResourceId, IList<string> resourceGuardOperationRequests, DataProtectionIdentityDetails identityDetails, IDictionary<string, BinaryData> serializedAdditionalRawData, string recoveryPointId, BackupRehydrationPriority rehydrationPriority, TimeSpan rehydrationRetentionDuration) : base(objectType, restoreTargetInfo, sourceDataStoreType, sourceResourceId, resourceGuardOperationRequests, identityDetails, serializedAdditionalRawData, recoveryPointId)
        {
            RehydrationPriority = rehydrationPriority;
            RehydrationRetentionDuration = rehydrationRetentionDuration;
            ObjectType = objectType ?? "AzureBackupRestoreWithRehydrationRequest";
        }

        /// <summary> Initializes a new instance of <see cref="BackupRestoreWithRehydrationContent"/> for deserialization. </summary>
        internal BackupRestoreWithRehydrationContent()
        {
        }

        /// <summary> Priority to be used for rehydration. Values High or Standard. </summary>
        public BackupRehydrationPriority RehydrationPriority { get; }
        /// <summary> Retention duration in ISO 8601 format i.e P10D . </summary>
        public TimeSpan RehydrationRetentionDuration { get; }
    }
}
