// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataProtectionBackup.Models
{
    /// <summary> Priority to be used for rehydration. Values High or Standard. </summary>
    public readonly partial struct BackupRehydrationPriority : IEquatable<BackupRehydrationPriority>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BackupRehydrationPriority"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BackupRehydrationPriority(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InvalidValue = "Invalid";
        private const string HighValue = "High";
        private const string StandardValue = "Standard";

        /// <summary> Invalid. </summary>
        public static BackupRehydrationPriority Invalid { get; } = new BackupRehydrationPriority(InvalidValue);
        /// <summary> High. </summary>
        public static BackupRehydrationPriority High { get; } = new BackupRehydrationPriority(HighValue);
        /// <summary> Standard. </summary>
        public static BackupRehydrationPriority Standard { get; } = new BackupRehydrationPriority(StandardValue);
        /// <summary> Determines if two <see cref="BackupRehydrationPriority"/> values are the same. </summary>
        public static bool operator ==(BackupRehydrationPriority left, BackupRehydrationPriority right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BackupRehydrationPriority"/> values are not the same. </summary>
        public static bool operator !=(BackupRehydrationPriority left, BackupRehydrationPriority right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BackupRehydrationPriority"/>. </summary>
        public static implicit operator BackupRehydrationPriority(string value) => new BackupRehydrationPriority(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BackupRehydrationPriority other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BackupRehydrationPriority other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
