// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataProtectionBackup.Models
{
    /// <summary> Field indicating sync type e.g. to sync only in case of failure or in all cases. </summary>
    public readonly partial struct BackupInstanceSyncType : IEquatable<BackupInstanceSyncType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BackupInstanceSyncType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BackupInstanceSyncType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DefaultValue = "Default";
        private const string ForceResyncValue = "ForceResync";

        /// <summary> Default. </summary>
        public static BackupInstanceSyncType Default { get; } = new BackupInstanceSyncType(DefaultValue);
        /// <summary> ForceResync. </summary>
        public static BackupInstanceSyncType ForceResync { get; } = new BackupInstanceSyncType(ForceResyncValue);
        /// <summary> Determines if two <see cref="BackupInstanceSyncType"/> values are the same. </summary>
        public static bool operator ==(BackupInstanceSyncType left, BackupInstanceSyncType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BackupInstanceSyncType"/> values are not the same. </summary>
        public static bool operator !=(BackupInstanceSyncType left, BackupInstanceSyncType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BackupInstanceSyncType"/>. </summary>
        public static implicit operator BackupInstanceSyncType(string value) => new BackupInstanceSyncType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BackupInstanceSyncType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BackupInstanceSyncType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
