// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataProtectionBackup.Models
{
    /// <summary> Sync BackupInstance Request. </summary>
    public partial class BackupInstanceSyncContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BackupInstanceSyncContent"/>. </summary>
        public BackupInstanceSyncContent()
        {
        }

        /// <summary> Initializes a new instance of <see cref="BackupInstanceSyncContent"/>. </summary>
        /// <param name="syncType"> Field indicating sync type e.g. to sync only in case of failure or in all cases. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BackupInstanceSyncContent(BackupInstanceSyncType? syncType, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SyncType = syncType;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Field indicating sync type e.g. to sync only in case of failure or in all cases. </summary>
        public BackupInstanceSyncType? SyncType { get; set; }
    }
}
