// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataProtectionBackup.Models
{
    /// <summary> Specifies the protection status of the resource. </summary>
    public readonly partial struct BackupInstanceProtectionStatus : IEquatable<BackupInstanceProtectionStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BackupInstanceProtectionStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BackupInstanceProtectionStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ConfiguringProtectionValue = "ConfiguringProtection";
        private const string ConfiguringProtectionFailedValue = "ConfiguringProtectionFailed";
        private const string ProtectionConfiguredValue = "ProtectionConfigured";
        private const string ProtectionStoppedValue = "ProtectionStopped";
        private const string SoftDeletedValue = "SoftDeleted";
        private const string SoftDeletingValue = "SoftDeleting";

        /// <summary> ConfiguringProtection. </summary>
        public static BackupInstanceProtectionStatus ConfiguringProtection { get; } = new BackupInstanceProtectionStatus(ConfiguringProtectionValue);
        /// <summary> ConfiguringProtectionFailed. </summary>
        public static BackupInstanceProtectionStatus ConfiguringProtectionFailed { get; } = new BackupInstanceProtectionStatus(ConfiguringProtectionFailedValue);
        /// <summary> ProtectionConfigured. </summary>
        public static BackupInstanceProtectionStatus ProtectionConfigured { get; } = new BackupInstanceProtectionStatus(ProtectionConfiguredValue);
        /// <summary> ProtectionStopped. </summary>
        public static BackupInstanceProtectionStatus ProtectionStopped { get; } = new BackupInstanceProtectionStatus(ProtectionStoppedValue);
        /// <summary> SoftDeleted. </summary>
        public static BackupInstanceProtectionStatus SoftDeleted { get; } = new BackupInstanceProtectionStatus(SoftDeletedValue);
        /// <summary> SoftDeleting. </summary>
        public static BackupInstanceProtectionStatus SoftDeleting { get; } = new BackupInstanceProtectionStatus(SoftDeletingValue);
        /// <summary> Determines if two <see cref="BackupInstanceProtectionStatus"/> values are the same. </summary>
        public static bool operator ==(BackupInstanceProtectionStatus left, BackupInstanceProtectionStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BackupInstanceProtectionStatus"/> values are not the same. </summary>
        public static bool operator !=(BackupInstanceProtectionStatus left, BackupInstanceProtectionStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BackupInstanceProtectionStatus"/>. </summary>
        public static implicit operator BackupInstanceProtectionStatus(string value) => new BackupInstanceProtectionStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BackupInstanceProtectionStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BackupInstanceProtectionStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
