// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataProtectionBackup.Models
{
    /// <summary> Parameters in Policy. </summary>
    public partial class BackupInstancePolicySettings
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BackupInstancePolicySettings"/>. </summary>
        public BackupInstancePolicySettings()
        {
            DataStoreParametersList = new ChangeTrackingList<DataStoreSettings>();
            BackupDataSourceParametersList = new ChangeTrackingList<BackupDataSourceSettings>();
        }

        /// <summary> Initializes a new instance of <see cref="BackupInstancePolicySettings"/>. </summary>
        /// <param name="dataStoreParametersList">
        /// Gets or sets the DataStore Parameters
        /// Please note <see cref="DataStoreSettings"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="OperationalDataStoreSettings"/>.
        /// </param>
        /// <param name="backupDataSourceParametersList">
        /// Gets or sets the Backup Data Source Parameters
        /// Please note <see cref="BackupDataSourceSettings"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="BlobBackupDataSourceSettings"/> and <see cref="KubernetesClusterBackupDataSourceSettings"/>.
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BackupInstancePolicySettings(IList<DataStoreSettings> dataStoreParametersList, IList<BackupDataSourceSettings> backupDataSourceParametersList, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DataStoreParametersList = dataStoreParametersList;
            BackupDataSourceParametersList = backupDataSourceParametersList;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary>
        /// Gets or sets the DataStore Parameters
        /// Please note <see cref="DataStoreSettings"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="OperationalDataStoreSettings"/>.
        /// </summary>
        public IList<DataStoreSettings> DataStoreParametersList { get; }
        /// <summary>
        /// Gets or sets the Backup Data Source Parameters
        /// Please note <see cref="BackupDataSourceSettings"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="BlobBackupDataSourceSettings"/> and <see cref="KubernetesClusterBackupDataSourceSettings"/>.
        /// </summary>
        public IList<BackupDataSourceSettings> BackupDataSourceParametersList { get; }
    }
}
