// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.DataProtectionBackup.Models
{
    public partial class BackupInstancePolicySettings : IUtf8JsonSerializable, IJsonModel<BackupInstancePolicySettings>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<BackupInstancePolicySettings>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<BackupInstancePolicySettings>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BackupInstancePolicySettings>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(BackupInstancePolicySettings)} does not support writing '{format}' format.");
            }

            if (Optional.IsCollectionDefined(DataStoreParametersList))
            {
                writer.WritePropertyName("dataStoreParametersList"u8);
                writer.WriteStartArray();
                foreach (var item in DataStoreParametersList)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(BackupDataSourceParametersList))
            {
                writer.WritePropertyName("backupDatasourceParametersList"u8);
                writer.WriteStartArray();
                foreach (var item in BackupDataSourceParametersList)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        BackupInstancePolicySettings IJsonModel<BackupInstancePolicySettings>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BackupInstancePolicySettings>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(BackupInstancePolicySettings)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeBackupInstancePolicySettings(document.RootElement, options);
        }

        internal static BackupInstancePolicySettings DeserializeBackupInstancePolicySettings(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IList<DataStoreSettings> dataStoreParametersList = default;
            IList<BackupDataSourceSettings> backupDatasourceParametersList = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("dataStoreParametersList"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<DataStoreSettings> array = new List<DataStoreSettings>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(DataStoreSettings.DeserializeDataStoreSettings(item, options));
                    }
                    dataStoreParametersList = array;
                    continue;
                }
                if (property.NameEquals("backupDatasourceParametersList"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<BackupDataSourceSettings> array = new List<BackupDataSourceSettings>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(BackupDataSourceSettings.DeserializeBackupDataSourceSettings(item, options));
                    }
                    backupDatasourceParametersList = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new BackupInstancePolicySettings(dataStoreParametersList ?? new ChangeTrackingList<DataStoreSettings>(), backupDatasourceParametersList ?? new ChangeTrackingList<BackupDataSourceSettings>(), serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<BackupInstancePolicySettings>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BackupInstancePolicySettings>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(BackupInstancePolicySettings)} does not support writing '{options.Format}' format.");
            }
        }

        BackupInstancePolicySettings IPersistableModel<BackupInstancePolicySettings>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BackupInstancePolicySettings>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeBackupInstancePolicySettings(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(BackupInstancePolicySettings)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<BackupInstancePolicySettings>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
