// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataProtectionBackup.Models
{
    /// <summary> List Restore Ranges Request. </summary>
    public partial class BackupFindRestorableTimeRangeContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BackupFindRestorableTimeRangeContent"/>. </summary>
        /// <param name="sourceDataStoreType"> Gets or sets the type of the source data store. </param>
        public BackupFindRestorableTimeRangeContent(RestoreSourceDataStoreType sourceDataStoreType)
        {
            SourceDataStoreType = sourceDataStoreType;
        }

        /// <summary> Initializes a new instance of <see cref="BackupFindRestorableTimeRangeContent"/>. </summary>
        /// <param name="sourceDataStoreType"> Gets or sets the type of the source data store. </param>
        /// <param name="startOn"> Start time for the List Restore Ranges request. ISO 8601 format. </param>
        /// <param name="endOn"> End time for the List Restore Ranges request. ISO 8601 format. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BackupFindRestorableTimeRangeContent(RestoreSourceDataStoreType sourceDataStoreType, DateTimeOffset? startOn, DateTimeOffset? endOn, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SourceDataStoreType = sourceDataStoreType;
            StartOn = startOn;
            EndOn = endOn;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="BackupFindRestorableTimeRangeContent"/> for deserialization. </summary>
        internal BackupFindRestorableTimeRangeContent()
        {
        }

        /// <summary> Gets or sets the type of the source data store. </summary>
        public RestoreSourceDataStoreType SourceDataStoreType { get; }
        /// <summary> Start time for the List Restore Ranges request. ISO 8601 format. </summary>
        public DateTimeOffset? StartOn { get; set; }
        /// <summary> End time for the List Restore Ranges request. ISO 8601 format. </summary>
        public DateTimeOffset? EndOn { get; set; }
    }
}
